
-- Main game loop
function Main()

	ShowAnyCursor(false);
	DisplaySplash("splash/playfirst_animated_logo.swf", "splash/playfirst_logo",4000);
	DisplaySplash("", "splash/distributor_logo",4000);
	AllowQuitCofirm(true);
	FlushMessages();

	ShowAnyCursor(true);
	DebugOut("Starting main loop");
	
	PlayMainMenuMusic();
	DoModal('scripts/loading.lua');
	if (LoginSystemEnabled() and
		GetCurrentUser() >= 0 and
		GetStrSetting('pfuser', '') ~= '') then
			SetSessionSetting('launchlogin', 'true');
			LaunchInitialLoginScreen();
			SetSessionSetting('launchlogin', 'false');
	end

	while (true) do
		if (IsGameStillOpen() == false) then
			if (InTrialMode()) then
				SetCurrentRestaurantByName("");
			end
			ClearTrialMode();
			
			DoMainWindow(GetRestartScreen());
		else
			Pause(1);
		end
	end
end

function LaunchInitialLoginScreen()
	SetAnonymousArea(true);
	SetSessionSetting('initiallogin', 'true');
	DoModal("scripts/login.lua");
	SetSessionSetting('initiallogin', 'false');
end


function CheckName()
	success = false ;
	
	if (GetNumUsers() > 0) then
	   if (GetCurrentUser() >= 0) then
		  success = true;
       else
          DoModal('scripts/chooseplayer.lua');
          success = true;
       end
	else
		name = UserNameEnterTextDialog('');

		if ( name ) then
			CreateNewUser(name);
			PostMessage( CreateNamedMessage( kPlayerLoggedIn, GetCurrentUserName() ) );
			success = true ;
		end
	end
	
	return success ;
end


function Login(anonymousOK, addInfo)
	if (LoginSystemEnabled() == false) then
		validUser = CheckName();
		if (validUser == true) then
			if (GetCurrentUser() < 0) then
				DoModal("scripts/chooseplayer.lua");
				if (GetCurrentUser() >= 0) then
					return true;
				end
			else
				return true;
			end
		end
		return false;
	else
		success = false ;
		SetAnonymousArea(anonymousOK);
		
		if (IsLoggedIn(anonymousOK)) then
			success = true;
		else
			if (GetNumUsers() == 0 or addInfo == true or GetCurrentUser() >= 0) then
				DoModal("scripts/login.lua");
				if (IsLoggedIn(anonymousOK)) then
					success = true;
				end
			else
				DoModal("scripts/chooseplayer.lua");
				if (IsLoggedIn(anonymousOK)) then
					success = true;
				end
			end
		end
		
		
		return success ;
	end
end

function ReceivedRematchRequest()
	result = DisplayDialog { 
		'scripts/yesno.lua', 
		body ='mprematchrequest',
		title = '' 
	};
	if (result=='yes') then 
		MetricEvent(eMPRematchAcceptEvent);
		AcceptRematch(true); 
	elseif (result=='no') then 
		AcceptRematch(false);
	end
end

function PreloadCustomers()
	InitializeRestaurantSettings();
	if (CustomersLoaded() == false) then
		DoModal( "scripts/ingameloading.lua" );
	end
end

function QuitQueryBody()

	if IsGameActive() then
		return "qquit";
	else
		return "qquitapp";
	end
end

function QuitQueryFunction() 
	result = DisplayDialog { 
		"scripts/yesno.lua", 
		body =QuitQueryBody(),
		title = "" 
	};
	if (result=='yes') then
		PostMessage( CreateNamedMessage( kQuitNow, "quit" ) );
	end
end








function SwapToModalSetName( winName )
	SetWindowNameMetric(winName);
	SwapToModal(winName);
end

function SwapToModalSetNameWithTip( winName, tipString, showTip )
	SetWindowNameMetric(winName);
	SwapToModalSetName(winName);
	DebugOut("DoMasdaodal "..fileToRead.." started! id="..id);
	if (showTip == true) then
		DisplayDialog { 
			"scripts/bigok.lua", 
			body =tipString,
			title = ""
		};
	end
end


function UserNameEnterTextDialog(defaulttext)
	gEnterNameValue = defaulttext;
	gEnterNameDescrip = 'entername';
	gEnterNameCheckFunction = IsNameInUse;
	gIllegalChars = kIllegalNameChars;
	gMaxInput = kMaxUserNameLength;
	return DoModal("scripts/entertext.lua");
end

function MyDinerEnterTextDialog(defaulttext)
	gEnterNameValue = defaulttext;
	gEnterNameDescrip = 'entermydinername';
	gEnterNameCheckFunction = IsDinerNameInUse;
	gMaxInput = kMaxMyDinerNameLength;
	gTextFieldImage = 'backgrounds/longtextfield';
	gFontSize = 14;
	return DoModal("scripts/entertext.lua");
end

function SelectMyDiner()
	if (GetBoolSetting("firstmydiner", true) or GetNumMyDiners() == 0) then
		CreateMyDiner(GetDefaultMyDinerName());
		newDinerNum = GetNumMyDiners();
		SetCurrentMyDiner(newDinerNum-1);
		DoModal("scripts/creatingdiner.lua");
		CloseAllWindows();
		DoModal("scripts/mydiner.lua");
	else
		name = DoModal("scripts/choosemydiner.lua");
		if (name == 'cancel') then
			-- Do nothing
		elseif (name == 'play') then
			result = DisplayDialog { 
				"scripts/threechoices.lua", 
				body ="md_clickondiner",
				title = "",
				choice1label="md_clickondinerendless",
				choice2label="md_clickondinermultiplayer",
				choice3label="md_clickondinercancel",
				popthrough = true 
			};
			if (result == 'choice1') then
				oldrestaurant = GetCurrentRestaurantName();
				SetCurrentRestaurantByName('mydiner');
				ForceMyWaiterCreation(true);
				DoModal('scripts/choosedifficulty.lua'); 
				SetCurrentRestaurantByName(oldrestaurant);
			elseif (result == 'choice2') then
				SetGlobalStrSetting('mplaunchhint','mydiner');
				LaunchMPEntry();
			else
				-- Do nothing
			end
		elseif (name == 'edit') then
			CloseAllWindows();
			DoModal('scripts/mydiner.lua'); 
		end
	end
end


function LaunchMapScreen(playMovie)
	if (GetCurrentGameMode() == 0) then
		restaurantName = GetLastCareerRestaurant();
						
		if (playMovie) then
			SetBoolSetting(restaurantName.."_intro_movie", true);
			
			comicName = GetRestaurantFolder(restaurantName).."/comics/intro.swf";			
			
			if (FileExists(comicName)) then
				comicName = ConvertSWFPath(comicName);
				SetDefaultStyle(ComicStyle);
				ActivateMovieClock(true);
				PlayMovieMusic(GetRestaurantMovieMusic(restaurantName, "intro"));
				
				DisplaySplash(comicName, "",1);
				PlayMainMenuMusic();
				ActivateMovieClock(false);
				SetDefaultStyle(DefaultStyle);
			end
			SaveSettings();
		end
	end
	CloseAllWindows();
	DoModal("scripts/chooserestaurant.lua");
end

function LaunchMPEntry()
	SetDefaultGameSettings();
	SetCurrentGameMode(1);
	SetMultiplayer("multi");
	SetGlobalBoolSetting("new_multiplayer", false);
	ForceMyWaiterCreation(false);
	CloseAllWindows();
	DoModal("scripts/mpentry.lua");
end

function LaunchMainMenu()
	DoModal(GetMainMenuScript());
end



function ForceMyWaiterCreation(forceCustomize)
	if (MultiplayerEnabled()) then
		if (HasCustomizedMPAvatar() == false) then
			DoModal("scripts/creatingwaiter.lua");
		end
		if (forceCustomize) then
			if (GetBoolSetting('firstmywaiter', true) == true) then
				DoFullScreenPopThrough(true);
				DoModal('scripts/floscloset.lua');
				DoFullScreenPopThrough(false);
			end
		end
	end
end


function CloseIGChatWindow()
	SetBoolSetting('chatclosed', true);
	SlideMovingWindow('movingchatwindow', false);
	EnableWindow('mpopenchat', true);
	EnableWindow('mpclosechat', false);
end

function MakeIGChatWindow()
	startOffVal = GetBoolSetting('chatclosed', false);
	if (MultiPlayerGame(true)==true) then
		return Group {
			MovingWindow
			{
				name="movingchatwindow",
				x=74,y=0,
				offy=-80,
				dirX = 0,
				dirY = -2,
				startoff = startOffVal,
				onDelay = 0,
				ChatWindow
				{
					x=0,
					y=0,
					name="mpchatwindow",
					
					Bitmap
					{
						image = 'multi/chatframe',
						
						SetStyle(ChatScrollArrowStyle);
						Button
						{
							x = 612, y = 5,
							command =
								function()
									ChatArrow(false);
								end
						};
						
						Button
						{
							x = 612, y = 26,
							vflip = true,
							command =
								function()
									ChatArrow(true);
								end
						};
						
						
						
						SetStyle(ChatScrollStyle);
						ScrolledWindow
						{
							x=41,y=5,w=592,h=28,
							name='chatscroller',
							Text
							{
								x = 0, y = 0, w = kMax-25, h = kMax,
								name="chatoutput",
								font=ChatFont,
								label='',
								flags=kHAlignLeft+ kVAlignTop,
								padding=0
							},
						},
						SetStyle(DefaultStyle);

						TextEdit 
						{
							name="chatentry",
							label=GetString("mpentertexthere"),
							font=ChatFont,
							length=100,
							clearinitial = true,
							flags=kHAlignLeft+ kVAlignCenter,
							x=41,y=50,w=546,h=24
						},
						Text
						{
							x= 0,
							y = 80,
							w = kMax,
							h = kMax,
							font = ChatTOSFont,
							flags = kHAlignCenter + kVAlignTop,
							label = 'mp_chat_tos'
						},
						Button
						{
							x = 595,
							y = 48,
							graphics = {'multi/mp_button_2_a', 'multi/mp_button_2_b', 'multi/mp_button_2_c'};
							label = 'mpsendchat',
							name = 'chatsend',
							default = true,
							command = 
								function()
									ChatSendButton();
								end
						};
						
						SetStyle(DefaultStyle);
						Button
						{
							x = 289,
							y = 89,
							xoffset = 0,
							yoffset = 0,
							graphics = 	{"multi/chatpulldown_a", "multi/chatpulldown_b", "multi/chatpulldown_c"},
							font = SmallButtonFont,
							label = 'mpopenchat',
							name = 'mpopenchat',
							command=
								function()
									SetBoolSetting('chatclosed', false);
									SlideMovingWindow('movingchatwindow', true);
									EnableWindow('mpopenchat', false);
									EnableWindow('mpclosechat', true);
									ClearMPChatFlash();
								end
						};
						
						Button
						{
							x = 289,
							y = 89,
							xoffset = 0,
							yoffset = 0,
							graphics = 	{"multi/chatpulldown_a", "multi/chatpulldown_b", "multi/chatpulldown_c"},
							font = SmallButtonFont,
							label = 'mpclosechat',
							name = 'mpclosechat',
							command=
								function()
									CloseIGChatWindow();
								end
						};
						
						Bitmap
						{
							x = 289,
							y = 89,
							image = "multi/chatpulldown_c",
							name = "chatflash",
							Text
							{
								x = 0, y = 0, w = kMax, h = kMax,
								label = 'mpopenchat',
								font = SmallButtonFont,
								flags = kHAlignCenter + kVAlignCenter
							};
						};
					
						
						SetStyle(DefaultStyle);
					};
				};
			};
		}
	else
		return Group {
		
		};
	end
end

function LaunchStoreAutoAdd(category)
	if (LoginSystemEnabled()) then
		if (Login(false, false)) then
			launchPath = "../action/addItem?sku="..category;
			LaunchHarnessPost( "manager", "content", launchPath );
		end
	else
		DisplayDialog{
			'scripts/ok.lua', 
			body ='login_mpnotenabled',
			title = ''
		};
	end
end

function LaunchStore(category)
	if (LoginSystemEnabled()) then
		if (Login(false, false)) then
			launchPath = "../game/diner-dash-flo-through-time/store";

			if (category ~= nil and category ~= '') then
				launchPath = launchPath.."/"..category;
			end

			LaunchHarnessPost( "manager", "content", launchPath );
		end
	else
		DisplayDialog{
			'scripts/ok.lua', 
			body ='login_mpnotenabled',
			title = ''
		};
	end
end
-- Return a function to be executed in a thread
return Main
